package com.wavemaker.runtime.security.provider.database;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCrypt;

/**
 * Created by arjuns on 17/1/17.
 */
public class BCryptPasswordEncoder implements PasswordEncoder {

    private static final Logger logger = LoggerFactory.getLogger(BCryptPasswordEncoder.class);

    @Override
    public String encode(CharSequence rawPass) {
        return null;
    }

    @Override
    public boolean matches(CharSequence rawPassword, final String encodedPassword) {
        if (encodedPassword == null || encodedPassword.length() == 0) {
            logger.warn("Empty encoded password");
            return false;
        }
        return BCrypt.checkpw(String.valueOf(rawPassword), encodedPassword);
    }
}

